#************************************************************************************
#                                                                                                  
#                                 Ex. RELAY_I2C.py                                       
#                                                                                                  
#************************************************************************************
#                                                                                                  
#  Board MCU   : RASPBERRY PI 3 MODEL B                                                         
#  Editor-IDE  : Geany 1.29                                                                      
#  Target Board Interface : ET-IOT HAT + ET-I2C REL8 (I2C-5V)                                                      
#                                                                                                                                                                                                                                             
#************************************************************************************

import smbus
import time

#---Open I2C interface---
bus = smbus.SMBus(1)    # use Port i2c-1

#---Define some device parameters ---
I2C_ADDR  = 0x20		# I2C device address ET-I2C REL8  ( JUMPER---> A2=LOW , A1=LOW , A0=LOW )

def RY0_ON():
	bus.write_byte(I2C_ADDR,0xFE&bus.read_byte(I2C_ADDR))

def RY0_OFF():
	bus.write_byte(I2C_ADDR,0x01|bus.read_byte(I2C_ADDR))
	
def RY1_ON():
	bus.write_byte(I2C_ADDR,0xFD&bus.read_byte(I2C_ADDR))

def RY1_OFF():
	bus.write_byte(I2C_ADDR,0x02|bus.read_byte(I2C_ADDR))

def RY2_ON():
	bus.write_byte(I2C_ADDR,0xFB&bus.read_byte(I2C_ADDR))

def RY2_OFF():
	bus.write_byte(I2C_ADDR,0x04|bus.read_byte(I2C_ADDR))
	
def RY3_ON():
	bus.write_byte(I2C_ADDR,0xF7&bus.read_byte(I2C_ADDR))

def RY3_OFF():
	bus.write_byte(I2C_ADDR,0x08|bus.read_byte(I2C_ADDR))

def RY4_ON():
	bus.write_byte(I2C_ADDR,0xEF&bus.read_byte(I2C_ADDR))
	
def RY4_OFF():
	bus.write_byte(I2C_ADDR,0x10|bus.read_byte(I2C_ADDR))
	
def RY5_ON():
	bus.write_byte(I2C_ADDR,0xDF&bus.read_byte(I2C_ADDR))

def RY5_OFF():
	bus.write_byte(I2C_ADDR,0x20|bus.read_byte(I2C_ADDR))
	
def RY6_ON():
	bus.write_byte(I2C_ADDR,0xBF&bus.read_byte(I2C_ADDR))

def RY6_OFF():
	bus.write_byte(I2C_ADDR,0x40|bus.read_byte(I2C_ADDR))
	
def RY7_ON():
	bus.write_byte(I2C_ADDR,0x7F&bus.read_byte(I2C_ADDR))
	
def RY7_OFF():
	bus.write_byte(I2C_ADDR,0x80|bus.read_byte(I2C_ADDR))
	
def ALL_ON():
	bus.write_byte(I2C_ADDR,0x00)

def ALL_OFF():
	bus.write_byte(I2C_ADDR,0xFF)

	
print ("Test ET-I2C REL8")
print ("Press CTRL-C to exit")

ALL_OFF()					# RY0-RY7 OFF
time.sleep(1)				# 1 second delay

try:
	while True:	
		RY0_ON()			# RY0 ON										
		time.sleep(1)		# 1 second delay
		RY1_ON()			# RY1 ON
		time.sleep(1)		# 1 second delay
		RY2_ON()			# RY2 ON
		time.sleep(1)		# 1 second delay
		RY3_ON()			# RY3 ON
		time.sleep(1)		# 1 second delay
		RY4_ON()			# RY4 ON
		time.sleep(1)		# 1 second delay
		RY5_ON()			# RY5 ON
		time.sleep(1)		# 1 second delay
		RY6_ON()			# RY6 ON
		time.sleep(1)		# 1 second delay
		RY7_ON()			# RY7 ON
		time.sleep(1)		# 1 second delay
		
		RY0_OFF()			# RY0 OFF										
		time.sleep(1)		# 1 second delay
		RY1_OFF()			# RY1 OFF
		time.sleep(1)		# 1 second delay
		RY2_OFF()			# RY2 OFF
		time.sleep(1)		# 1 second delay
		RY3_OFF()			# RY3 OFF
		time.sleep(1)		# 1 second delay
		RY4_OFF()			# RY4 OFF
		time.sleep(1)		# 1 second delay
		RY5_OFF()			# RY5 OFF
		time.sleep(1)		# 1 second delay
		RY6_OFF()			# RY6 OFF
		time.sleep(1)		# 1 second delay
		RY7_OFF()			# RY7 OFF
		time.sleep(1)		# 1 second delay
		
		ALL_ON()			# RY0-RY7 ON
		time.sleep(1)		# 1 second delay
		
		ALL_OFF()			# RY0-RY7 OFF
		time.sleep(1)		# 1 second delay
						
except KeyboardInterrupt:
	print("End of Program")

